include "exemples/Caml Light/Rubik/cube2x2/divers/types.ml";;
include "exemples/Caml Light/Rubik/divers/divers.ml";;
include "exemples/Caml Light/Rubik/cube2x2/divers/section_marques.ml";;
include "exemples/Caml Light/Rubik/divers/couleurs.ml";;
include "exemples/Caml Light/Rubik/cube2x2/divers/graphisme.ml";;
include "exemples/Caml Light/Rubik/cube2x2/divers/boutons.ml";;


(* liste des coins : ici il n'y a que des coins! *)
let coins = indices;;


(*- sous groupe de Rubik R de M -*)

(* rotation totale des coins *)
let rtc m =
  let rtc_aux k = let f = fun_of_mv1 k in
      let indexc i = if f i = st i then 1
        else if f i = transpose (st i) then 2 else 0 in
        (list_it (prefix +) (map indexc coins) 0) mod 3
  in rtc_aux (ker m)
;;

(* test d'appartenance d'un mouvement au sous-groupe R *)
let est_dans_R m = rtc m = 0;;

(*- fin de sous groupe de Rubik R de M -*)


(*- mouvement alatoire -*)

random__init (unix__time ());;

(* permutation alatoire des coins *)
let pc_r () =
  let rlc = random_list coins in
    fun i -> assoc i (map2 (fun x y -> (x, y)) coins rlc)
;;

(* exposant alatoire pour les coins *)
let ec_r = fun i -> random__int 3;;

(* mouvement alatoire gnral *)
let mv1_r () = nouveau_mv1 (pc_r ()) ec_r;;

(* mouvement de Rubik alatoire *)
let mv1_rubik_r () =
  (* rotation d'un seul coin i *)
  let rot_coin i n =
    nouveau_mv1 (*(fun x -> x)*) (fun x -> x) (fun j -> if j = i then n else 0)
  in
    let m = ref (mv1_r ()) in
      if rtc !m <> 0 then m := !m /*/ rot_coin [|1; 1; 1|] (3 - rtc !m);
      !m
;;

(*- fin de mouvement alatoire -*)


(*- rsolution par niveaux du Rubik's cube 2x2 -*)

(* initialisation du cube : mise en place des mouvements lmentaires de Rubik *)
let nouveau_cube mouvement context dessine liste_mouvements =
  
  let listeops = ref []
  and dessine () = dessine context mouvement.mv1
  in
    let op_externes liste_ops =
      let fct x () =
        let t = x /:/ transpose context.matrice in
          mouvement.mv1 <- mouvement.mv1 /*/ rub t;
          if liste_mouvements then (
              print_string (nom_de_face t ^ " ");
              liste_ops := !liste_ops @ [nom_de_face t];
            );
          dessine ()
      and fct' x () =
        let t = x /:/ transpose context.matrice in
          mouvement.mv1 <- mouvement.mv1 /*/ rub' t;
          if liste_mouvements then (
              print_string (nom_de_face t ^ "' ");
              liste_ops := !liste_ops @ [nom_de_face t ^ "'"];
            );
          dessine ()
      in
        let (a, d, h) = vect (map_vect fct id)
        and (a', d', h') = vect (map_vect fct' id)
        and (p, g, b) = vect (map_vect fct idm)
        and (p', g', b') = vect (map_vect fct' idm)
        in (OPS (a, d, h), OPS (a', d', h'), OPS (p, g, b), OPS (p', g', b'))
    
    and op_internes () =
      let fct x () =
        mouvement.mv1 <- mouvement.mv1 /*/ rub x;
        print_string (nom_de_face x ^ " ");
        dessine ()
      and fct' x () =
        mouvement.mv1 <- mouvement.mv1 /*/ rub' x;
        if liste_mouvements then print_string (nom_de_face x ^ "' ");
        dessine ()
      in
        let (o, v, blanc) = vect (map_vect fct id)
        and (o', v', blanc') = vect (map_vect fct' id)
        and (r, b, j) = vect (map_vect fct idm)
        and (r', b', j') = vect (map_vect fct' idm)
        in (OPS (o, v, blanc), OPS (o', v', blanc'), OPS (r, b, j), OPS (r', b', j'))
    
    and op_globales () =
      let rotation pp () = context.matrice <- context.matrice /./ pp;
        dessine () in
        let (a, d, h) = vect (map_vect rotation (map_vect rot id))
        and (a', d', h') = vect (map_vect rotation (map_vect rot' id))
        in
          (OPS (a, d, h), OPS (a', d', h'))
    
    in
      let op_ext = op_externes listeops and op_int = op_internes () in
        let op_from_strings liste_ops =
          let (OPS (orange, vert, blanc), OPS (orange', vert', blanc'), OPS (rouge,
          bleu, jaune), OPS (rouge', bleu', jaune')) = op_int
          in
            let aux s = assoc s
              [("orange", orange); ("vert", vert); ("blanc", blanc);
                ("orange'", orange'); ("vert'", vert'); ("blanc'", blanc');
                ("rouge", rouge); ("bleu", bleu); ("jaune", jaune);
                ("rouge'", rouge'); ("bleu'", bleu'); ("jaune'", jaune')]
            in
              let rec op_from_strings_aux liste_ops =
                match liste_ops with
                  t :: r -> aux t :: op_from_strings_aux r
                  | [] -> []
              in op_from_strings_aux liste_ops
        in
          {mouvement1 = mouvement; context1 = context; dessine1 = dessine;
            op_globales1 = op_globales (); op_externes1 = op_ext;
            op_internes1 = op_int; liste_ops1 = listeops;
            op_from_strings1 = op_from_strings;
            boutons1 = make_vect 1 {titre = ""; orx = 0; ory = 0; largeur = 0;
              hauteur = 0; couleur = 0; action = fun () -> ()}
          }
;;

(* rsolution du cube 2x2 *)
exception Orienter_les_coins;;
exception Descendre_coin;;
exception Remonter_coin;;
exception Placer_les_coins;;

let resoudre_le_cube cube =
  (* (y, m) = pos0 x : le minicube d'indice x est  l'emplacement d'indice y et m est sa matrice *)
  (* de dplacement (telle que y=xm) (repre ADH) *)
  let pos0 =
    let pos mv1 x =
      let p = cube.context1.matrice in
        let m = transpose p /./ (fun_of_mv1 mv1) (x /:/ transpose p) /./ p
        in
          x /:/ m, m
    in
      (fun x -> pos cube.mouvement1.mv1 x)
  and
  (OPS (a, d, h), OPS (a', d', h'), OPS (p, g, b), OPS (p', g', b')) = cube.op_externes1
  and
  (OPS (_, _, h0), OPS (_, _, h0')) = cube.op_globales1
  in
    
    let niveau_superieur () =
      
      (* niveau suprieur *)
      
      let placer_et_orienter_les_coins () =
        let descendre_coin () =
          let w, m = pos0 [|1; 1; 1|] in
            if (w <> [|1; 1; 1|]) || (m <> id) then
              match vect w with
                | (- 1, 1, 1) -> exe [p'; b'; p]
                | (- 1, - 1, 1) -> exe [p; b; b; p']
                | (1, - 1, 1) -> exe [g; b; g']
                | (1, 1, 1) -> exe [a; b; a'; b']
                | (- 1, 1, - 1) -> exe [b']
                | (- 1, - 1, - 1) -> exe [b; b]
                | (1, - 1, - 1) -> exe [b]
                | (1, 1, - 1) -> ()
                | _ -> raise Descendre_coin
        and remonter_coin () =
          let (v, m) = pos0 [|1; 1; 1|] in
            if (v = [|1; 1; 1|]) && (m = id) then ()
            else
              let w = m.(2) in match vect w with
                  | (1, 0, 0) -> exe [d; a'; d'; a]
                  | (0, 1, 0) -> exe [a'; d; a; d']
                  | (0, 0, - 1) -> exe [a; b'; a'; b; b; d; a'; d'; a]
                  | _ -> raise Remonter_coin
        in
          for i = 0 to 3 do
            descendre_coin ();
            remonter_coin ();
            exe [h0]
          done;
      
      in
        placer_et_orienter_les_coins ()
    
    
    and niveau_inferieur () =
      
      (* niveau infrieur *)
      
      let placer_les_coins () =
        let permuter () =
          (* laisse fixe le coin frontal droit et permute circulairement 
          les autres dans le sens direct vu d'en bas *)
          exe [b; a; b'; p'; b; a'; b'; p]
        and permuter' () =
          (* laisse fixe le coin frontal droit et permute circulairement 
          les autres dans le sens indirect vu d'en bas *)
          exe [p'; b; a; b'; p; b; a'; b']
        in
          let chercher_un_coin_bien_place () =
            let i = ref 0 in
              while !i < 4 && fst (pos0 [|1; 1; - 1|]) <> [|1; 1; - 1|] do
                exe [h0];
                incr i
              done;
              !i
          in
            let j = chercher_un_coin_bien_place () in
              
              if j = 4 (* aucun coin bien plac *) then (
                  permuter ();
                  let _ = chercher_un_coin_bien_place () in ()
                )
              else ();
              
              let v, _ = pos0 [|- 1; - 1; - 1|] in match vect v with
                  | (1, - 1, - 1) -> permuter ()
                  | (- 1, 1, - 1) -> permuter' ()
                  | (- 1, - 1, - 1) -> ()
                  | _ -> raise Placer_les_coins
      
      
      and orienter_les_coins () =
        let faire_tourner () =
          (* fait tourner les coins frontaux infrieurs sur eux-mmes: 
          le coin gauche dans le sens direct, le coin droit en sens inverse *)
          exe [p'; b'; p; b'; p'; b; b; p];
          exe [a; b; a'; b; a; b; b; a']
        and
        faire_tourner' () =
          (* fait tourner les coins frontaux infrieurs sur eux-mmes:
          le coin droit dans le sens direct, le coin gauche en sens inverse *)
          exe [a; b; b; a'; b'; a; b'; a'];
          exe [p'; b'; b'; p; b; p'; b; p]
        in
          let orienter_frontal_inferieur_droit () =
            let _, m = pos0 [|1; 1; - 1|] in
              let v = m.(2) in
                match vect v with
                  | (0, 0, 1) -> ()
                  | (- 1, 0, 0) -> faire_tourner' ()
                  | (0, - 1, 0) -> faire_tourner ()
                  | _ -> raise Orienter_les_coins
          in
            for i = 0 to 2 do
              orienter_frontal_inferieur_droit ();
              exe [h0']
            done
      
      in
      (* faire un quart de tour si la permutation des coins est impaire *)
      (* car 'placer les coins' suppose cette permutation paire *)
        if (sign coins (sur cube.mouvement1.mv1) = - 1) then exe [b]
        else ();
        placer_les_coins ();
        orienter_les_coins ()
    
    in
      cube.liste_ops1 := [];
      try
        let ctx = cube.context1.matrice in
          (
            niveau_superieur ();
            niveau_inferieur ();
            cube.context1.matrice <- ctx
          );
          cube.dessine1 ();
          !(cube.liste_ops1)
      with
      | Orienter_les_coins ->
            print_string "erreur dans orienter_les_coins\n"; !(cube.liste_ops1)
        | Placer_les_coins ->
            print_string "erreur dans placer_les_coins\n"; !(cube.liste_ops1)
;;

(*- fin de rsolution par niveaux du Rubik's cube 2x2 -*)

(* cube muet invisible dans l'tat 'mv1'  orient de faon standard *)
(* utilis par la fonction 'est_rubik' *)
let nouveau_cube_muet mv1 =
    nouveau_cube mv1 {matrice = id} (fun _ _ -> ()) false
;;

(* cube invisible dans l'tat 'mv1' orient de faon standard *)
(* crivant les mouvements de ses faces - quarts de tours - *)
(* et les renvoyant sous forme de liste *)
let nouveau_cube_verbeux mv1 =
  nouveau_cube mv1 {matrice = id} (fun _ _ -> ()) true
;;

(* cube avec affichage graphique dans l'tat 'mv1' orient de faon standard *)
(* suppose l'ouverture pralable de la fentre graphique pour fonctionner *)
let nouveau_cube_graphique mv1 =
  nouveau_cube mv1 {matrice = id} dessine_cube true
;;

(* test d'appartenance d'un mouvement au sous-groupe R *)
(* fond sur la rsolution par niveaux *)
let est_rubik mv1 =
  let mouvement = {mv1 = mv1} in
    let _ = resoudre_le_cube (nouveau_cube_muet mouvement)
    in
      mouvement.mv1 = e
;;

(* cube avec mouvement rsultant d'une squence alatoires de *)
(* mouvements de Rubik lmentaires *)
let melanger cube =
  let (OPS (a, d, h), OPS (a', d', h'), OPS (p, g, b), OPS (p', g', b')) = cube.op_externes2
  and s = vect_of_list (random_list (liste 12))
  and v = make_vect 12 (fun () -> ()) in
    v.(s.(0)) <- a; v.(1) <- d; v.(2) <- h; v.(s.(3)) <- a'; v.(s.(4)) <- d'; v.(s.(5)) <- h';
    v.(s.(6)) <- p; v.(s.(7)) <- g; v.(s.(8)) <- b; v.(s.(9)) <- p'; v.(s.(10)) <- g'; v.(s.(11)) <- b';
    let t = make_vect 30 (fun () -> ()) in
      for i = 0 to 29 do
        t.(i) <- v.(random__int 12);
      done;
      exe (list_of_vect t)
;;


(* EXEMPLES *)

let mv1 = mv1_rubik_r ();;
est_dans_R mv1;;
est_rubik mv1;;

let cube = nouveau_cube_graphique {mv1 = mv1};;
boucle1 cube
(
  fun () -> let n = list_length (resoudre_le_cube cube) in
          (printf__printf "\nnombre de quarts de tour: %d\n" n;
            print_newline ()
          )
)
(
  fun () -> cube.mouvement1.mv1 <- mv1_rubik_r (); cube.dessine1 ()
        (*  fun () -> melanger cube *)
)
;;

let cube = nouveau_cube_verbeux {mv1 = mv1};;
resoudre_le_cube cube;;

(*-------------------------------------------------------------------------------------------------------------------------*)

(* Pour utiliser directement ce qui suit, interrompre la boucle ci-dessus et procder par lignes entires.
   Slectionner et envoyer ensemble les 6 lignes suivantes (let cube = ...) ...

let cube = nouveau_cube_graphique {mv1 = mv1};;
graphics__open_graph " 612x612";;
cube.dessine1();;
let (OPS (a0, d0, h0), OPS(a0', d0', h0')) = cube.op_globales1;;
let (OPS (a, d, h), OPS(a', d', h'), OPS(p, g, b), OPS(p', g', b')) = cube.op_externes1;;
let (OPS (orange, vert, blanc), OPS(orange', vert', blanc'), OPS(rouge, bleu, jaune), OPS(rouge', bleu', jaune')) = cube.op_internes1;;

... puis excuter une par une certaines des commandes qui suivent : (slectionner une ligne puis l'envoyer)


a0();;
a0'();;

d0();;
d0'();;

h0();;
h0'();;


a();;
a'();;

p();;
p'();;

d();;
d'();;

g();;
g'();;

h();;
h'();;

b();;
b'();;


orange();;
orange'();;

rouge();;
rouge'();;

vert();;
vert'();;

bleu();;
bleu'();;

blanc();;
blanc'();;

jaune();;
jaune'();;

*)


(*----------------- Quelques formules utilises pour rsoudre le cube 2x2 --------------------*)

(*

  (* NIVEAU SUPRIEUR face haute, blanche en principe *)

  (* placement du coin suprieur frontal droit  partir d'en dessous: face blanche *)      
  (* vers le bas : [a,b']b[d a'] *)
exe [a;b';a';b;b;d;a';d';a];;
  (* mouvement inverse *)
exe (rev[a';b;a;b;b;d';a;d;a']);;

  (* placement du coin suprieur frontal droit  partir de : face blanche frontale *)
  (* avec autre face correcte *)
exe [d;a';d';a];;
  (* mouvement inverse *)
exe [a';d;a;d'];;

  (* placement du coin suprieur frontal droit  partir de : face blanche  droite *)
  (* avec autre face correcte *)
exe [a';d;a;d'];;


  (* NIVEAU INFRIEUR (le prcdent dj fait) *)

  (* PERMUTER LES COINS *)

  (* laisse fixe le coin frontal droit et permute circulairement les autres : *)
  (* [p' b.a] *)
exe [p';b;a;b';p;b;a';b'];;
  (* mouvement inverse *)
exe (rev [p;b';a';b;p';b';a;b]);;

  (* ORIENTER LES COINS *)

  (* fait tourner les coins frontaux sur eux-mmes: le coin gauche *)
  (* dans le sens des aiguilles d'une montre le coin droit en sens inverse *)
  (* (ab).[b,a'] (p'b').[b',p] *)

exe [a;b;b;a';b';a;b';a'];;
exe [p';b';b';p;b;p';b;p];;
  (* mouvement inverse *)
exe [p';b';p;b';p';b;b;p];;
exe [a;b;a';b;a;b;b;a'];;

*)